//----------------------------------------------------------------------------
//  Project Themes
//  
//  (C) 2007 Sebastian Ledesma
//
//  SUBSYSTEM:    Themes Application
//  FILE:         thmsdlgc.h
//  AUTHOR:       Sebastian Ledesma
//
//  OVERVIEW
//  ~~~~~~~~
//  Class definition for TThemesDlgClient (TDialog).
//
//----------------------------------------------------------------------------
#if !defined(thmsdlgc_h)              // Sentry, use file only if it's not already included.
#define thmsdlgc_h

#include "themsapp.rh"                  // Definition of all resources.


#include <owl/commctrl.h>

#include <owl/tabctrl.h>
#include <owl/gauge.h>
#include <owl/listbox.h>
#include <owl/combobox.h>
//{{TDialog = TThemesDlgClient}}
struct TThemesDlgClientXfer {
//{{TThemesDlgClientXFER_DATA}}
    TComboBoxData  pComboBox1;
    TListBoxData  pListBox1;
//{{TThemesDlgClientXFER_DATA_END}}
};

class TThemesDlgClient : public TDialog {
  public:
    TThemesDlgClient(TWindow* parent, TResId resId = IDD_CLIENT, TModule* module = 0);
    virtual ~TThemesDlgClient();


//{{TThemesDlgClientVIRTUAL_BEGIN}}
  public:
    virtual void SetupWindow();
    virtual void CleanupWindow();
//{{TThemesDlgClientVIRTUAL_END}}

//{{TThemesDlgClientRSP_TBL_BEGIN}}
  protected:
    void EvTimer(uint timerId);
    void OnButton1();
//{{TThemesDlgClientRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(TThemesDlgClient);

//{{TThemesDlgClientXFER_DEF}}
  protected:
    TComboBox* pComboBox1;
    TListBox* pListBox1;
    TGauge* pGauge;
    TTabControl* pTabControl;

//{{TThemesDlgClientXFER_DEF_END}}
};    //{{TThemesDlgClient}}


#endif  // thmsdlgc_h sentry.
