//----------------------------------------------------------------------------
//  Project Themes
//  
//  (C) 2007 Sebastian Ledesma
//
//  SUBSYSTEM:    Themes Application
//  FILE:         thmsdlgc.cpp
//  AUTHOR:       Sebastian Ledesma
//
//  OVERVIEW
//  ~~~~~~~~
//  Source file for implementation of TThemesDlgClient (TDialog).
//
//----------------------------------------------------------------------------

#include <owl/pch.h>

#include "themsapp.h"
#include "thmsdlgc.h"
#include "moredilg.h"


//
// Build a response table for all messages/commands handled by the application.
//
DEFINE_RESPONSE_TABLE1(TThemesDlgClient, TDialog)
//{{TThemesDlgClientRSP_TBL_BEGIN}}
  EV_WM_TIMER,
  EV_BN_CLICKED(IDC_BUTTON1, OnButton1),
//{{TThemesDlgClientRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{TThemesDlgClient Implementation}}


//--------------------------------------------------------
// TThemesDlgClient
// ~~~~~~~~~~
// Construction/Destruction handling.
//
static TThemesDlgClientXfer TThemesDlgClientData;

TThemesDlgClient::TThemesDlgClient(TWindow* parent, TResId resId, TModule* module)
:
  TDialog(parent, resId, module)
{
//{{TThemesDlgClientXFER_USE}}
  pComboBox1 = new TComboBox(this, IDC_COMBOBOX1, 1);
  pListBox1 = new TListBox(this, IDC_LISTBOX1);
  pGauge = new TGauge(this, IDC_PROGRESSBAR1);
  pTabControl = new TTabControl(this, IDC_TABCONTROL1);

  SetTransferBuffer(&TThemesDlgClientData);
//{{TThemesDlgClientXFER_USE_END}}

  // INSERT>> Your constructor code here.
	SetBkgndColor(RGB(255,225, 132));
}


TThemesDlgClient::~TThemesDlgClient()
{
  Destroy();

  // INSERT>> Your destructor code here.
}

void TThemesDlgClient::SetupWindow()
{
  TDialog::SetupWindow();

  // INSERT>> Your code here.
  pComboBox1->AddString("TComboBox Item 1");
  pComboBox1->AddString("TComboBox Item 2");
  pComboBox1->AddString("TComboBox Item 3");
  pComboBox1->AddString("TComboBox Item 4");
  pListBox1->SetSelIndex(2);

  pListBox1->AddString("TListBox Item 1");
  pListBox1->AddString("TListBox Item 2");
  pListBox1->AddString("TListBox Item 3");
  pListBox1->SetSelIndex(1);

  pTabControl->Add("Tab 1");
  pTabControl->Add("Tab 2");
  pTabControl->Add("Tab 3");

  SetTimer(1, 20); //timer 1 set each 10 milliseconds

}

void TThemesDlgClient::CleanupWindow()
{
  TDialog::CleanupWindow();

  // INSERT>> Your code here.
	KillTimer(1);
}

void TThemesDlgClient::EvTimer(uint timerId)
{
    TDialog::EvTimer(timerId);

  // INSERT>> Your code here.
	int value=pGauge->GetValue();
   value++;
   if (value==100)
   	value=0;
   pGauge->SetValue(value);

}


void TThemesDlgClient::OnButton1(){
  // INSERT>> Your code here.
  TMoreDialog*   xTMoreDialog = new TMoreDialog(this);
  xTMoreDialog->Execute();
  delete xTMoreDialog;

}



