
	  /********************************************************************
		*
		*   Source File:  TPOFILE.CPP
		*   Author:       Whitehouse
		*   Module:
		*   Program Desc:
		*   Date:         Tue Oct 18 14:29:35 1994
		*   Language:     OWL 2.0 C++
		*
	  ********************************************************************/

#include "printing.h"
#pragma hardstop

extern TPrinter* TMyHotPrinter;

PrintoutList1::PrintoutList1(const char *far title)
 : TPrintout(title)
{
	TotalPages = 0;
	morerecords=TRUE;
}

void PrintoutList1::GetDialogInfo(int& minPage,
											int& maxPage,
											int& selFromPage,
											int& selToPage)
{
	TPrinter printer;
	TPrintDC* printDC = new TPrintDC(printer.GetSetup().GetDriverName(),
												printer.GetSetup().GetDeviceName(),
												printer.GetSetup().GetOutputName(),
												printer.GetSetup().GetDevMode());

  //
  // store the horizontal and vertical size of each page
  //
  TSize printSize(printDC->GetDeviceCaps(HORZRES),
						printDC->GetDeviceCaps(VERTRES));

  //
  // call SetPrintParams to set the data members
  //
  SetPrintParams(printDC, printSize);

  delete printDC;

  // page range is 1..TotalPages
  minPage = 1;
  maxPage = TotalPages;

  selFromPage = selToPage = 0;
  TMyHotPrinter->GetSetup().Copies   = 1;
  TMyHotPrinter->GetSetup().FromPage = 1;
  TMyHotPrinter->GetSetup().ToPage   = 999;

  // This is how you prespecify a landscape format for your printout
  // The landscape selection will show on the printer setup box
  DEVMODE* dm = const_cast<DEVMODE*> (TMyHotPrinter->GetSetup().GetDevMode());
  dm->dmFields |= DM_ORIENTATION;
  dm->dmOrientation = DMORIENT_LANDSCAPE;
}

void PrintoutList1::SetPrintParams(TPrintDC* dc, TSize pageSize)
{
  TPrintout::SetPrintParams(dc, pageSize);
  // if you can figure this out ahead of time, do so and set TotalPages
  // if you don't know, just set it to a high number
  // this example assumes we don't know the total page count ahead of time.
  TotalPages=32000;
}

void PrintoutList1::BeginPrinting()
{
	 char filename[MAXPATH];

	 GetWindowsDirectory(filename,MAXPATH);
	 lstrcat(filename,"\\WIN.INI");
	 fd=fopen(filename,"r");
	 if(!fd)
	 {
		 // pop an error box
		 morerecords=FALSE;
	 }
}

BOOL PrintoutList1::HasPage(int /*page*/)
{
	 // Note that we use the boolean "morerecords" instead of page number
	 // because we assume we don't know how many total pages we have.
	 // For this example, we could have been smart and counted the lines in WIN.INI
	 // before hand (in GetDialogInfo() for instance) and then we could use
	 // a page number as the stopping  point.
	 // But this example is trying to illustrate a situation where you
	 // have no idea how many lines you will be printing!

	 return (morerecords);
}

void PrintoutList1::PrintPage(int page, TRect&, unsigned)
{
	char message[400], working[50];
	int linecount, maxlinecount, deltay;
	int tab[5] = {135, 1400, 2350, 5150, 7650};

	// you must instantiate a myform for each page!
	myform = new Form;
	myform->prnDC = DC;
	myform->Open();

	// Draw a boxed header using the form class member functions
	// myform uses MM_HIENGLISH, so all numbers are inches X 1000
	// I'm also assuming the box is being printed on an 8/5 x 11" page
	// in landscape.  You could set the dimensions of your box dynamically
	// (and more accurately) by using GetDeviceCaps(HORZRES) and
	//  GetDeviceCaps(VERTRES) to figure out the total page size first.

	myform->Box ( 0,    0, 10300,  7875);
	myform->Line( 0,  400, 10300,     0);
	myform->Line( 0,  680, 10300,     0);
	myform->ShadedFillRect(3, 3, 10294, 394, -99);
	myform->Line( tab[1]-80,  400, 0, 7850-400);
	myform->Line( tab[2]-80,  400, 0, 7850-400);

	//put the page number in the header, along with column headings
	myform->SetFont("Helv",14, FW_BOLD);
	sprintf(message,"Page %d",page);
	myform->TextRight(10230,150, message);
	myform->SetFont("Helv",14, FW_BOLD);
	myform->TextAt( tab[0], 120, "Listing of WIN.INI File");

	myform->TextAt( tab[0], 420, "Line #");
	myform->TextAt( tab[1], 420, "Col 2");
	myform->TextAt( tab[2], 420, "Line Contents");

	// print a gratuituous bitmap on each page!
	myform->DrawBMP(8000, 800, ID_BMP_EAGLE);

	// now setup to print the "live" data
	linecount=0;
	myform->SetFont("Helv",8, FW_NORMAL);

	// figure out the line spacing base on the current font
	TSize mysize = DC->GetTextExtent ("A", 1);
	deltay= mysize.cy;

	// figure out the maximum number of lines we can fit on the page
	// based on box height, header space, and the line spacing
	// (You could do this once for the entire TPrintout object if you choose
	// in GetDialogInfo or BeginPrinting()).

	maxlinecount = (7875-800)/deltay;


	// now let's print the data!
	do{
		fgets(message,sizeof(message)-1,fd);

		// check to see if we have no more lines to print
		// if you were listing a database, you would check for eof
		if(feof(fd))
		{
			morerecords=FALSE;
			break;
		}

		// check to see if the printer cancel button has been pressed by the user
		if(TMyHotPrinter->GetUserAbort())
		{
			morerecords=FALSE;
			break;
		}

		// print the information
		sprintf(working,"%d",linecount);
		myform->TextRight(tab[1]-20, 700 + linecount*deltay, working);
		myform->TextAt(tab[2], 700 + linecount*deltay, message);

	} while(++linecount<maxlinecount);

	delete myform;
}

void PrintoutList1::EndPrinting()
{
	fclose(fd); // close the file (or close your database)
}

