	  /********************************************************************
		*
		*   Source File:  TIP.CPP
		*   Author:       Whitehouse
		*   Module:       Dialog implementation for WINEM
		*   Program Desc: Envelope Manager for Windows
		*   Date:         Sun Apr 16 22:31:53 1995
		*   Language:     OWL 2.0 C++
		*
		********************************************************************/

#include "printing.h"
#pragma hdrstop
#include <share.h>

char preferences[] = "Preferences";
char nexttip[]= "NextTip";

#define SIZE_OF_TIP   1000

#define DO_TIP   WM_USER + 6008

DEFINE_RESPONSE_TABLE1(TipDlg, TDialog)
	EV_WM_TIMER,
	EV_BN_CLICKED(ID_TIPOK, CmOk),
	EV_BN_CLICKED(ID_TIPNEXT, CmNext),
	EV_BN_CLICKED(ID_TIPPREV, CmPrev),
	EV_BN_CLICKED(ID_TIPHELP, CmHelp),
	EV_COMMAND(DO_TIP, DisplayCurrentTip),
	EV_WM_CTLCOLOR,
	//EV_WM_PAINT,
	EV_WM_ACTIVATE,
END_RESPONSE_TABLE;

TipDlg::TipDlg(TWindow *parent, TResId resId, TModule *module)
	: TDialog(parent, resId, module)
{
	 TipStatic1 = new TStatic(this, IDC_STATIC1, 100);
	 TipStatic2 = new TStatic(this, IDC_STATIC2, 100);
	 TipStatic3 = new TStatic(this, IDC_STATIC3, SIZE_OF_TIP);
	 TipFont    = new TFont("MS Sans Serif",14,0,0,0,FW_NORMAL);
	 HeaderFont = new TFont("MS Sans Serif",16,0,0,0,FW_BOLD,FF_DONTCARE,TRUE);
	 tipmessage = new char[SIZE_OF_TIP];
	 EditBrush= new TBrush(::GetSysColor(COLOR_WINDOW));
	 icon=LoadIcon(GetApplicationObject()->GetInstance(),MAKEINTRESOURCE(LIGHTBULB));
}

TipDlg::~TipDlg()
{
	 delete TipFont;
	 delete HeaderFont;
	 delete EditBrush;
	 delete [] tipmessage;
	 delete TipIni;
}

void TipDlg::SetupWindow()
{
	char *p, working[80], filename[MAXPATH], LoadDirectory[MAXPATH];
	int i;

	TDialog::SetupWindow();
	// !KR I moved this function from DisplayCurrentTip() so it only
	// has to execute once.
	TipStatic2->SetText("Did you know...?");
	i = maxtipno = currenttipno = 0;
	GetApplicationObject()->GetModuleFileName(LoadDirectory, MAXPATH);
	// now remove file name
	p=strrchr(LoadDirectory, '\\');
	*p='\x0';
	lstrcat(LoadDirectory, "\\");

	sprintf(TIPIniFile,"%s%s", LoadDirectory, "TIP.INI");
	TipIni= new TProfile(preferences,TIPIniFile);

	sprintf(filename,"%s%s", LoadDirectory, "WEMTIPS.MSG");
	// !KR Depending on how much .ini file access you are going to
	// be doing the TProfile class is a handy one if for no reason
	// other than it saves on typing.
	// TProfile ini(preferences, TIPIniFile);
	// ini.GetString(nexttip, working, sizeof(working));
	// ini.GetString(tips, working, sizeof(working), "Yes");
	// I'm not sure if the syntax is 100% here but you get the idea.
	if((fhelp=_fsopen(filename,"rb",SH_DENYNO))!=NULL)
	{
		 fread(&helpoffset,2,2000,fhelp);
		 do{
			 if(helpoffset[i]) maxtipno=i;
			 else break;
			 i++;
		 } while(i<2001);
	} else {
		 PostMessage(WM_COMMAND,ID_TIPOK);
		 return; // return here or we GPF!
	}

	TipIni->GetString(nexttip,working, sizeof(working),"");
	currenttipno = atoi(working);
	TipStatic1->SetText("");

	TipStatic3->SetWindowFont(*TipFont, TRUE);
	TipStatic2->SetWindowFont(*HeaderFont, TRUE);
	TipIni->GetString("Tips",working, sizeof(working),"Yes");

	if(strstr(working,"Yes")) CheckDlgButton(ID_TIPCHECK,TRUE);
	PostMessage(WM_COMMAND,DO_TIP);
}

// !KR added to get icon to display
void TipDlg::EvTimer(uint)
{
	KillTimer(1);
	PaintIcon();
}

void TipDlg::CmOk()
{
	char working[80];

	if(IsDlgButtonChecked(ID_TIPCHECK)) lstrcpy(working,"Yes");
	else lstrcpy(working,"No");
	TipIni->WriteString("Tips",working);

	// move to the next time for next program load
	currenttipno++;
	if(currenttipno>maxtipno) currenttipno=0;
	sprintf(working,"%d",currenttipno);
	TipIni->WriteString("NextTip",working);

	TDialog::CmOk();
}

void TipDlg::CmPrev()
{
	currenttipno--;
	if(currenttipno<0) currenttipno=maxtipno;
	DisplayCurrentTip();
}

void TipDlg::CmNext()
{
	currenttipno++;
	if(currenttipno>maxtipno) currenttipno=0;
	DisplayCurrentTip();
}

void TipDlg::CmHelp()
{
}

void TipDlg::DisplayCurrentTip()
{
	fseek(fhelp,helpoffset[currenttipno],SEEK_SET);
	fgets(tipmessage,SIZE_OF_TIP-1,fhelp);
	TipStatic3->SetText(tipmessage);
}

// !KR Added this function which just displays the icon
void TipDlg::PaintIcon()
{
	// !KR OWL way of drawing the icon. I don't know if you can get
	// by with the hard coded values of 12,12. You might have problems
	// at different resolutions. Rather consider using something like...
	TClientDC dc(*this);
	int x = GetSystemMetrics(SM_CYCAPTION);
	int offset = (x/2) + (x * .1);
	dc.DrawIcon(offset, offset, icon);
	TipStatic2->SetText("Did you know...?");
}

void TipDlg::CleanupWindow()
{
	fclose(fhelp);
	TDialog::CleanupWindow();
}

HBRUSH TipDlg::EvCtlColor(HDC hDC, HWND hWndChild, UINT ctlType)
{
	POINT point;
	UINT cid;

	// this will get a white text background even with Cntrl3D turned on.
	cid = ::GetDlgCtrlID(hWndChild);
	if(cid == IDC_STATIC1 ||
		cid == IDC_STATIC2 ||
		cid == IDC_STATIC3)
	{
		EditBrush->UnrealizeObject();
		point.x=point.y=0;
		::ClientToScreen(hWndChild,&point);
		SetBrushOrg(hDC,point.x,point.y);
		return (*EditBrush);
	}

	return (TDialog::EvCtlColor(hDC,hWndChild,ctlType));  // No special action required
}

// !KR This seems to be as good a place as anywhere to start
// the timer.
void TipDlg::EvActivate(uint, bool, HWND)
{
	DefaultProcessing();
	SetTimer(1, 50);
}


