	  /********************************************************************
		*
		*   Source File:  FORM.CPP
		*   Author:       Whitehouse
		*   Module:       C++ Source file for WINEM application
		*   Program Desc: Envelope Manager for Windows
		*   Date:         Tue Oct 18 14:29:35 1994
		*   Language:     OWL 2.0 C++
		*
		********************************************************************/

#include "printing.h"
#pragma hardstop

Form::Form(void)
{
	Pen=0;
	pfont=0;
}


Form::~Form(void)
{
	delete(Pen);
	delete(pfont);
}

int Form::Open(void)
{
	// Get the Logical page coordinates (from mm!) convert to 1/1000 inch
	rPage.bottom = 0;
	rPage.left   = 0;
	rPage.right  = prnDC->GetDeviceCaps (HORZSIZE) * (100/2.54);
	rPage.top    = prnDC->GetDeviceCaps (VERTSIZE) * (100/2.54);
	Pen   = new TPen(TColor::Black,14,PS_SOLID);
	pfont = new TFont
	(
					 "New Times Roman",
					 -::MulDiv(10, 1000, 72),
					 0, 0, 0,
					 FW_NORMAL,
					 DEFAULT_PITCH,
					 FALSE, FALSE, FALSE,  // italic, underline, strikeout
					 ANSI_CHARSET,
					 OUT_TT_ONLY_PRECIS,
					 CLIP_DEFAULT_PRECIS,
					 DRAFT_QUALITY
	);


	// Now switch to units of 1/1000 inches.
	prnDC->SetMapMode(MM_HIENGLISH );

	// Set the origin to the LOWER left corner (all units + now) (on LOGICAL! page in pixels)
	prnDC->SetViewportOrg(TPoint(0,prnDC->GetDeviceCaps (VERTRES)));
	prnDC->SelectObject(*pfont);
	prnDC->SelectObject(*Pen);

	return (IDOK);
}


void Form::Box(TRect r)
{
	Box(r.left,r.top,r.right-r.left,r.top-r.bottom);
}


void Form::Box(int x, int y, int width, int height)
{
	prnDC->Rectangle(rPage.left+100+x,
						  rPage.top-100-y,
						  rPage.left+100+x+width,
						  rPage.top -100-y-height);
}


void Form::ShadedFillRect(int x, int y, int width, int height, int percentfill)
{
	static WORD pattern[] =
	{
		 0xFE, 0xFE, 0xEF, 0xFE, 0xEF, 0xEF, 0xFE, 0xEF
	};

	// 1 bit is white!!
	// 0 bit is black!!

	HBITMAP hbmp = CreateBitmap(8,8,1,1,pattern);
	TBrush *brush = new TBrush(TBitmap(hbmp));
	prnDC->FillRect(rPage.left+100+x,
						 rPage.top-100-y,
						 rPage.left+100+x+width,
						 rPage.top -100-y-height, *brush);
	delete brush;
	DeleteObject(hbmp);
}

void Form::CenterLine(int y, int length, int linewidth)
{
	int xctr;

	xctr = (int)(rPage.left + ((rPage.right - rPage.left) / 2 - length/2));
	if(xctr<0) xctr = rPage.left;

	delete Pen;
	Pen   = new TPen(TColor::Black,linewidth,PS_SOLID);
	prnDC->SelectObject(*Pen);
	Line(xctr,y,length,0);
}

void Form::TextCenter(int y, char far *message)
{
	int xctr;

	TSize size;
	size = prnDC->GetTextExtent (message, strlen (message));

	xctr = (int)(rPage.left + ((rPage.right - rPage.left) / 2 - size.cx / 2));
	if (xctr < rPage.left)
			 xctr = rPage.left;
	TextAt(xctr,y,message);

}


void Form::TextAt(TPoint p, char *message)
{
	prnDC->TextOut(p, message);
}

void Form::TextAt(int x, int y, char *message)
{
	prnDC->TextOut(rPage.left+100+x, rPage.top-100-y,message);
}


void Form::TextAt(int left, int top, int IDS)
{
	char buffer[300];

// TModule's version of LoadString may have a bug!!!! (ref: Bob Arnson)
//      GetApplicationObject()->LoadString(IDS,buffer,255);

	::LoadString(GetApplicationObject()->GetInstance(),IDS,buffer,255);
	prnDC->TextOut(rPage.left+100+left,
						rPage.top-100-top,
						buffer);
}


void Form::TextRight(int x, int y, char far *message)
{
	RECT rText;

	rText.left   = rPage.left;
	rText.right  = rText.left+x;
	rText.top    = rPage.top-100-y;
	rText.bottom = rText.top-y;
	prnDC->DrawText(message, -1, rText, DT_RIGHT| DT_NOPREFIX | DT_NOCLIP | DT_WORDBREAK);
}


int Form::DrawText(int left, int top, int width, int height, int IDS)
{
	int textheight;
	RECT rText;
	char buffer[300];

// TModule's version of LoadString has bugs!!!!  Bob Arneson
//      GetApplicationObject()->LoadString(IDS,buffer,255);

	::LoadString(GetApplicationObject()->GetInstance(),IDS,buffer,255);

	rText.left   = rPage.left+left+100;
	rText.right  = rText.left+width;
	rText.top    = rPage.top-100-top;
	rText.bottom = rText.top-height;
	textheight = prnDC->DrawText(buffer, -1, rText, DT_LEFT| DT_NOPREFIX | DT_NOCLIP | DT_WORDBREAK);
	return(textheight);
}

int Form::DrawText(int left, int top, int width, int height, char *message)
{
	int textheight;
	TRect rText;

	rText.left   = rPage.left+left+100;
	rText.right  = rText.left+width;
	rText.top    = rPage.top-100-top;
	rText.bottom = rText.top+height;
	rText.bottom = rText.top-height;
	textheight = prnDC->DrawText(message, lstrlen(message), rText, DT_LEFT | DT_NOPREFIX | DT_NOCLIP | DT_WORDBREAK);
//	prnDC->Rectangle(rText);  Interesting diagnostic!
// textheight = ::DrawText(*prnDC, message, -1, &rText, DT_LEFT | DT_NOPREFIX | DT_NOCLIP | DT_WORDBREAK);
	return(textheight);
}



void Form::Line(int left, int top, int width, int height)
{
	prnDC->MoveTo(rPage.left+100+left,
					rPage.top-100-top);
	prnDC->LineTo(rPage.left+100+left+width,
					rPage.top-100-top-height);
}


void Form::Line(TPoint p, int width)
{
	Line(p.x,p.y,width);
}

void Form::Line(int x, int y, int width)
{
	Line(x,y,width);
}


void Form::SetFont(char *typeface, int pointsize, int weight, int italic, int angle)
{
	LOGFONT lf;

	pfont->GetObject (lf);

	// lfHeight must be signed minus if you are specifying the font height
	// If you want to specify the cell height, use a + value.
	// there are 72 points per inch and we are using a 1/1000 inch logical resolution

	lf.lfHeight = -::MulDiv(pointsize, 1000, 72);
	lf.lfWidth  = 0;   // choose reasonable width
	lf.lfWeight = weight;
	lf.lfItalic = italic;
	lf.lfEscapement = angle*10;

//	lf.lfPitchAndFamily = FF_ROMAN;
	lf.lfPitchAndFamily = FF_DONTCARE;
//#define FF_DONTCARE         (0<<4)  /* Don't care or don't know. */
//#define FF_ROMAN            (1<<4)  /* Variable stroke width, serifed. */
												/* Times Roman, Century Schoolbook, etc. */
//#define FF_SWISS            (2<<4)  /* Variable stroke width, sans-serifed. */
												/* Helvetica, Swiss, etc. */
//#define FF_MODERN           (3<<4)  /* Constant stroke width, serifed or sans-serifed. */
												/* Pica, Elite, Courier, etc. */
//#define FF_SCRIPT           (4<<4)  /* Cursive, etc. */
//#define FF_DECORATIVE       (5<<4)  /* Old English, etc. */


	lstrcpy(lf.lfFaceName,typeface);
	delete pfont;

	pfont = new TFont(&lf);
	prnDC->SelectObject(*pfont);
	prnDC->SetTextColor(TColor::Black); // set to black for text in this function
}


int Form::DrawBMP(int x, int y, int resourceid)
{
	 TDib* dib =0;
	 try
	 {
		 dib = new TDib(GetApplicationObject()->GetInstance(), resourceid);
	 }
	 catch (TGdiBase::TXGdi)
	 {
//		 ::MessageBox(parent,"Cannot access bitmap resource!",MB_OK);
		 return FALSE;
	 }

	TRect dest (TPoint(rPage.left+100+x,rPage.top-100-y), TSize(dib->Width()*10/3,-dib->Height()*10/3));
	TRect src (0, 0, dib->Width(), dib->Height ());
	prnDC->StretchDIBits (dest, src, *dib);
	delete dib;

	return TRUE;

}

int Form::DrawBMP(int x, int y, const char *filename)
{
	 char message[MAXPATH+50];

	 TDib* dib =0;
	 try
	 {
		 dib = new TDib(filename);
	 }
	 catch (TGdiBase::TXGdi)
	 {
		 sprintf(message,"Can't open bitmap file %s",filename);
		 return FALSE;
	 }

	TRect dest (TPoint(rPage.left+100+x,rPage.top-100-y), TSize(dib->Width()*10/3,-dib->Height()*10/3));
	TRect src (0, 0, dib->Width(), dib->Height ());
	prnDC->StretchDIBits (dest, src, *dib);
	delete dib;

	return TRUE;
}

void Form::ExtTextOut(int x, int y, char *text, int escapement)
{
	TRect Area;
	TSize MySize;
	double    L, W, LW, D;
	TPoint    pTL, pTR, pBL, pBR, pShift;

	Area.left = pTL.x = rPage.left+100+x;
	Area.top  = pTL.y = rPage.top-100-y;
	MySize = prnDC->GetTextExtent(text, lstrlen(text));
	if (escapement!= 0)
	{
		// font rotated, calculate rectangle to contain rotated font - WOW
		L = MySize.cx;
		W = MySize.cy;

		D = (double)( ((float)(2*3.14159) * (float)(escapement) / 3600) );

		// calculate all four corners than take limits
		pTR.x = pTL.x + (L * cos( D ) );
		pTR.y = pTL.y - (L * sin( D ) );

		pBL.x = pTL.x - (W * sin( D ) );
		pBL.y = pTL.y - (W * cos( D ) );

		LW = sqrt((double)(L*L) + (double)(W*W));
		// calculate extra rotation angle
		if (L>0) D += atan((double)W/(double)L);
		pBR.x = pTL.x + (LW * cos( D ) );
		pBR.y = pTL.y - (LW * sin( D ) );

		Area.top    = max(pTL.y, max(pTR.y, max(pBL.y, pBR.y))) ;
		Area.bottom = min(pTL.y, min(pTR.y, min(pBL.y, pBR.y))) ;
		Area.left   = min(pTL.x, min(pTR.x, min(pBL.x, pBR.x))) ;
		Area.right  = max(pTL.x, max(pTR.x, max(pBL.x, pBR.x))) ;

		// size changed
		// keep upper left corner in same location
		pShift.x = Area.left - pTL.x;
		pShift.y = Area.top  - pTL.y;
		OffsetRect(&Area, -pShift.x, -pShift.y);
		pTL.x -= pShift.x;
		pTL.y -= pShift.y;
	} else {
	  // no rotation
		Area.bottom = Area.top  - MySize.cy; // remember, our coordinates are reversed!
		Area.right  = Area.left + MySize.cx;
	}

	 // Draw the text
	 prnDC->ExtTextOut(pTL.x, pTL.y,             /* x and y coordinates       */
							 ETO_OPAQUE,
							 &Area,                    /* address of RECT structure */
							 text,                     /* string to write    */
							 lstrlen(text),            /* characters in string      */
							 (LPINT) NULL);            /* default character spacing */
}


BOOL Form::ExtTextOut(int x, int y, unsigned int flags, TRect far *rect, char far *text, int len, int far *lpdx)
{
	 int ytemp;
	 BOOL rc;
	 TPoint pTL;

	 pTL.x = rPage.left+100+x;
	 pTL.y = rPage.top-100-y;
	 rect->left  += rPage.left+100;
	 rect->right += rPage.left+100;
	 ytemp = rPage.top - 100 - rect->top;
	 rect->top  = ytemp;
	 ytemp = rPage.top - 100 - rect->bottom;
	 rect->bottom = ytemp;

	 //	 OffsetRect(rect,100,0);

	 rc = prnDC->ExtTextOut(pTL.x, pTL.y,   /* x and y coordinates       */
							 flags,
							 rect,               /* address of RECT structure */
							 text,                /* string to write    */
							 len,                 /* characters in string      */
							 (LPINT) NULL);       /* default character spacing */

	return(rc);
}

void Form::SetPenSize(int size)
{

	delete Pen;
	Pen   = new TPen(TColor::Black,size,PS_SOLID);
	prnDC->SelectObject(*Pen);

}



