#ifndef __MMPLAYER_H
#define __MMPLAYER_H
/*
#if defined(MM_DLL)
	#define _MMCLASS _export
#elif defined(MM_APP)
	#define _MMCLASS _import
#else
	#define _MMCLASS
#endif
*/
#define STRICT
#ifndef __STRING_H
#include <string.h>
#endif
#ifndef __WINDOWS_H
#include <windows.h>
#endif
#ifndef __MMSYSTEM_H
#include <mmsystem.h>
#endif
#ifndef __MEM_H
#include <mem.h>
#endif
#pragma hdrstop

#define MS MCI_FORMAT_MILLISECONDS
#define HMS MCI_FORMAT_HMS
#define MSF MCI_FORMAT_MSF
#define FRAMES MCI_FORMAT_FRAMES
#define BYTES MCI_FORMAT_BYTES
#define SAMPLES MCI_FORMAT_SAMPLES
#define TMSF MCI_FORMAT_TMSF
#define CHAPTERS MCI_FORMAT_CHAPTERS
#define MM_SYNC MCI_NOTIFY | MCI_WAIT
#define MM_ASYNC MCI_NOTIFY

typedef struct yieldprocstruct_tag {
	DWORD classInst;
	DWORD dwData;
	BOOL	msgLoop;
} YIELD_PROC_STRUCT;

class TMMPlayer {
	public:
		TMMPlayer(HWND hWnd, const char* device = 0,
								BOOL errReporting = FALSE);
		TMMPlayer(HWND hWnd, const char* filename, const char* device = 0,
							DWORD flags = 0, BOOL errReporting = FALSE);
		~TMMPlayer();
		DWORD Open(const char* filename, const char* device = 0);
		DWORD Open(const char* filename,
								const char* device,
								HWND parent,
								DWORD style,
								DWORD flags);
		DWORD Close();
		DWORD Play(DWORD flags = MM_SYNC);
		DWORD Play(const char* filename,
								DWORD flags = MM_SYNC);
		DWORD Play(DWORD from, DWORD to,
								DWORD flags = MM_SYNC);
		DWORD	PlayResource(int resId, HINSTANCE hInst,
								UINT flags = SND_SYNC | SND_NODEFAULT);
		DWORD PlayResource(const char* resName, HINSTANCE hInst,
								UINT flags = SND_SYNC | SND_NODEFAULT);
		DWORD Record(DWORD flags = MCI_NOTIFY | MCI_RECORD_OVERWRITE);
		DWORD Record(DWORD from, DWORD to,
								DWORD flags = MM_SYNC | MCI_RECORD_OVERWRITE);
		DWORD Save(const char* filename = 0,
								DWORD flags = MCI_SAVE_FILE | MM_SYNC);
		DWORD Load(const char* filename, DWORD flags = MCI_LOAD_FILE | MM_SYNC);
		DWORD Cue(DWORD flags = MM_SYNC);
		DWORD Delete(DWORD from = 0, DWORD to = 0);
		DWORD Stop();
		DWORD Seek(DWORD to = 0, DWORD flags = MCI_SEEK_TO_START);
		DWORD Pause(DWORD flags = MM_SYNC);
		DWORD Resume();

		DWORD Erase();
		DWORD Rewind();
		DWORD FastForward();

		BOOL	CanEject();
		BOOL	CanPlay();
		BOOL	CanRecord();
		BOOL	CanSave();
		BOOL	HasAudio();
		BOOL	HasVideo();
		BOOL	IsMediaPresent();
		BOOL	IsOpen();
		BOOL	IsReady();
		BOOL	UsesFiles();

		DWORD GetStatusItem(DWORD item);
		DWORD GetDeviceCaps(DWORD item);
		DWORD GetSysInfoItem(DWORD item, char* info, int dev);
		DWORD GetInfoItem(DWORD item, char* info);
		DWORD GetDeviceName(char* name);
		DWORD GetDeviceType();
		DWORD GetFileName(char* filename);
		DWORD GetPosition();
		DWORD GetLength();
		DWORD GetMode();
		DWORD GetTimeFormat();
		RECT	GetVideoRect();
		DWORD GetVolume();
		DWORD	GetStatus();

		DWORD Cut(DWORD flags = MM_ASYNC);
		DWORD Paste(DWORD flags = MM_ASYNC);
		DWORD Copy(DWORD flags = MM_ASYNC);
		DWORD Set(DWORD flags, DWORD options = 0);
		DWORD SetAudioOff();
		DWORD SetAudioOn();
		void 	SetCallbackWindow(HWND hWnd);
		void	SetParent(HWND hWnd);
		DWORD SetTimeFormat(DWORD format);
		DWORD SetVideoOff();
		DWORD SetVideoOn();
		DWORD SetPosition(DWORD position);
		DWORD SetVolume(int volume);
		DWORD SetVolume(int lvol, int rvol);
		void	SetErrorReporting(BOOL err);
		void	SetYieldProcData(DWORD data);
		void	SetYieldProc(BOOL enabled, DWORD data = 0, BOOL msgLoop = FALSE);
		virtual BOOL YieldProcess(UINT devID, DWORD data) {return 0;}
		DWORD ErrCode;

	protected:
		static int CALLBACK _export YieldProc(UINT devID, DWORD data);
		void ReportError(const char* title = "MultiMedia Error");
		HWND hWindow;
		UINT DeviceID;
		BOOL DeviceOpen;
		UINT ErrorReporting;
		char ErrMsg[255];
		DWORD YieldProcData;
		FARPROC yieldProc;

		YIELD_PROC_STRUCT ypStruct;
};

inline DWORD TMMPlayer::Erase() {
	return Delete(0, GetLength());
}

inline DWORD TMMPlayer::PlayResource(int resId, HINSTANCE hInst, UINT flags) {
	return PlayResource((LPSTR)MAKEINTRESOURCE(resId), hInst, flags);
}

inline DWORD TMMPlayer::Rewind() {
	return Seek();
}

inline DWORD TMMPlayer::FastForward() {
	return Seek(0, MM_SYNC | MCI_SEEK_TO_END);
}

inline BOOL TMMPlayer::CanEject() {
	return (BOOL)GetDeviceCaps(MCI_GETDEVCAPS_CAN_EJECT);
}

inline BOOL TMMPlayer::CanPlay() {
	return (BOOL)GetDeviceCaps(MCI_GETDEVCAPS_CAN_PLAY);
}

inline BOOL TMMPlayer::CanRecord() {
	return (BOOL)GetDeviceCaps(MCI_GETDEVCAPS_CAN_RECORD);
}

inline BOOL TMMPlayer::CanSave() {
	return (BOOL)GetDeviceCaps(MCI_GETDEVCAPS_CAN_SAVE);
}

inline BOOL TMMPlayer::HasAudio() {
	return (BOOL)GetDeviceCaps(MCI_GETDEVCAPS_HAS_AUDIO);
}

inline BOOL TMMPlayer::HasVideo() {
	return (BOOL)GetDeviceCaps(MCI_GETDEVCAPS_HAS_VIDEO);
}

inline BOOL TMMPlayer::IsMediaPresent() {
	return (BOOL)GetStatusItem(MCI_STATUS_MEDIA_PRESENT);
}

inline BOOL TMMPlayer::IsOpen() {
	return DeviceOpen;
}

inline BOOL TMMPlayer::IsReady() {
	return (BOOL)GetStatusItem(MCI_STATUS_READY);
}

inline BOOL TMMPlayer::UsesFiles() {
	return (BOOL)GetDeviceCaps(MCI_GETDEVCAPS_USES_FILES);
}

inline DWORD TMMPlayer::GetDeviceType() {
	return GetDeviceCaps(MCI_GETDEVCAPS_DEVICE_TYPE);
}

inline DWORD TMMPlayer::GetFileName(char* filename) {
	return GetInfoItem(MCI_INFO_FILE, filename);
}

inline DWORD TMMPlayer::GetPosition()  {
	return GetStatusItem(MCI_STATUS_POSITION);
}

inline DWORD TMMPlayer::GetLength() {
	return GetStatusItem(MCI_STATUS_LENGTH);
}

inline DWORD TMMPlayer::GetMode() {
	return GetStatusItem(MCI_STATUS_MODE);
}

inline DWORD TMMPlayer::GetTimeFormat() {
	return GetStatusItem(MCI_STATUS_TIME_FORMAT);
}

inline DWORD TMMPlayer::GetStatus() {
	return GetStatusItem(MCI_STATUS_MODE);
}

inline DWORD TMMPlayer::SetAudioOff() {
	return Set(MCI_SET_AUDIO | MCI_SET_OFF, MCI_SET_AUDIO_ALL);
}

inline DWORD TMMPlayer::SetAudioOn() {
	return Set(MCI_SET_AUDIO | MCI_SET_ON, MCI_SET_AUDIO_ALL);
}

inline void TMMPlayer::SetCallbackWindow(HWND hWnd) {
	hWindow = hWnd;
}

inline void TMMPlayer::SetParent(HWND hWnd) {
	hWindow = hWnd;
}

inline DWORD TMMPlayer::SetTimeFormat(DWORD format) {
	return Set(MCI_SET_TIME_FORMAT, format);
}

inline DWORD TMMPlayer::SetVideoOff() {
	return Set(MCI_SET_VIDEO | MCI_SET_OFF);
}

inline DWORD TMMPlayer::SetVideoOn() {
	return Set(MCI_SET_VIDEO | MCI_SET_ON);
}

inline DWORD TMMPlayer::SetPosition(DWORD position) {
	return Seek(position);
}

inline void TMMPlayer::SetErrorReporting(BOOL err) {
	ErrorReporting = err;
}

#endif
