/////////////////////////////////////////////////////////////////////
//                                                                 //
// RECORDER.H Header for recorder.cpp
//                                                                 //
//	Recorder Copyright  1995 by Kent Reisdorph, All rights reserved//
//                                                                 //
/////////////////////////////////////////////////////////////////////

#define STRICT
#ifndef __DIR_H
#include <dir.h>
#endif
#ifndef __STDIO_H
#include <stdio.h>
#endif
#ifndef __DIRECT_H
#include <direct.h>
#endif
#ifndef __OWL_APPLICAT_H
#include <owl\applicat.h>
#endif
#ifndef __OWL_FRAMEWIN_H
#include <owl\framewin.h>
#endif
#ifndef __OWL_DIALOG_H
#include <owl\dialog.h>
#endif
#ifndef __OWL_STATIC_H
#include <owl\static.h>
#endif
#ifndef __OWL_EDIT_H
#include <owl\edit.h>
#endif
#ifndef ____OWL_CONTROL_H
#include <owl\control.h>
#endif
#ifndef ____OWL_SLIDER_H
#include <owl\slider.h>
#endif
#ifndef ____OWL_OPENSAVE_H
#include <owl\opensave.h>
#endif
#ifndef ____OWL_RADIOBUT_H
#include <owl\radiobut.h>
#endif
#ifndef __MMPLAYER_H
#include "mmplayer.h"
#endif
#ifndef __ODA_H
#include "oda.h"
#endif
#ifndef __ODACHECK_H
#include "odacheck.h"
#endif
#ifndef __MARKER_H
#include "marker.h"
#endif
#ifndef __CAPSDLG_H
#include "capsdlg.h"
#endif
#pragma hdrstop

#include "recorder.rh"

class TMainDlg : public TDialog {
	public:
		TMainDlg(TWindow* parent, int resId);
		~TMainDlg() {KillTimer(1); delete Player;}
		void EvHScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
		void EvVScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
		void EvMouseMove(UINT, TPoint&);
		LRESULT MarkerNotify(WPARAM, LPARAM);
		DWORD MediaLength;
		LRESULT MciNotify(WPARAM, LPARAM);
	private:
		void SetupWindow();
		void EvTimer(UINT);
		void CmOk();
		void CmFileOpen();
		void CmFileSave();
    void CmAbout();
		void NewFile();
		void Play();
		void Record();
		void FastForward();
		void Rewind();
		void Stop();
		void Pause();
		void EraseAll();
		void ErasetoStart();
		void ErasetoEnd();
		void FrameAdvance();
		void FrameBack();
		void SetVolume();
		void VideoButton();
		void AudioButton();
		void UpdateScreenData();
		void UpdateMarkerData();
		void UpdateStatus();
		void ShowDevCaps();
		void ShowEditButtons(UINT sw);
		TODAButton3* PlayButton;
		TODAButton3* StopButton;
		TODACheckBox* RecordModeSwitch;
		TODACheckBox* VideoBtn;
		TODACheckBox* AudioBtn;
		TStatic* SliderStatic;
		TStatic* VolumeStatic;
		TStatic* FileStatic;
		TStatic* LengthStatic;
		TStatic* PositionStatic;
		TStatic* PlayStatic;
		TStatic* Hint;
		TStatic* PlayerStatus;
		TStatic* StatusFrom;
		TStatic* StatusTo;
		TStatic* VideoStatic;
		TStatic* AudioStatic;
		TRadioButton* PlayNormal;
		TRadioButton* PlayFast;
		TRadioButton* PlaySlow;
		TODAButton4* ErStart;
		TODAButton4* ErEnd;
		TODAButton4* ErAll;
		THSlider* Slider;
		TKMarker* Marker;
		TVSlider* VolumeControl;
		TMMPlayer* Player;
		DWORD LastPosition;
		DWORD DevType;
		int Status;
		char Filename[100];
		char Pos[6];
		TOpenSaveDialog::TData filenameData;

	DECLARE_RESPONSE_TABLE(TMainDlg);
};

