/////////////////////////////////////////////////////////////////////
//                                                                 //
// RECORDER.CPP Program to demonstrate use of TMMPlayer class      //
//                                                                 //
//	Recorder Copyright  1995 by Kent Reisdorph, All rights reserved//
//                                                                 //
/////////////////////////////////////////////////////////////////////
#include "recorder.h"

DEFINE_RESPONSE_TABLE1(TMainDlg, TDialog)
	EV_WM_TIMER,
	EV_WM_HSCROLL,
	EV_WM_VSCROLL,
	EV_WM_MOUSEMOVE,
	EV_WM_CHAR,
	EV_MESSAGE(MM_MARKERNOTIFY, MarkerNotify),
	EV_MESSAGE(MM_MCINOTIFY, MciNotify),
	EV_SB_ENDSCROLL(idSlider, UpdateScreenData),
	EV_SB_ENDSCROLL(idVolume, SetVolume),
	EV_COMMAND(idcPlay, Play),
	EV_COMMAND(idcStop, Stop),
	EV_COMMAND(idcPause, Pause),
	EV_COMMAND(idcRewind, Rewind),
	EV_COMMAND(idcFastForward, FastForward),
	EV_COMMAND(idcRecord, Record),
	EV_COMMAND(idcErasetoStart, ErasetoStart),
	EV_COMMAND(idcErasetoEnd, ErasetoEnd),
	EV_COMMAND(idcEraseAll, EraseAll),
	EV_COMMAND(idcFileOpen, CmFileOpen),
	EV_COMMAND(idcFileSave, CmFileSave),
	EV_COMMAND(idcNewFile, NewFile),
	EV_COMMAND(idcFrameAdvance, FrameAdvance),
	EV_COMMAND(idcFrameBack, FrameBack),
	EV_COMMAND(idcDevCaps, ShowDevCaps),
	EV_COMMAND(idcAudio, AudioButton),
	EV_COMMAND(idcVideo, VideoButton),
	EV_COMMAND(idcAbout, CmAbout),
END_RESPONSE_TABLE;

TMainDlg::TMainDlg(TWindow* parent, int resId)
			: TDialog(parent, resId), TWindow(parent),
			filenameData(OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST,
			"Wave (*.wav)|*.wav|Avi video (*.avi)|*.avi|"
			"FLI Animation (*.fli, *flc)|*.fli;*.flc|"
			"MIDI (*.mid, *.rmi)|*.mid;*.rmi|"
			"All files (*.*)|*.*",
			0, "", "*")
{
	Hint = new TStatic(this, idsHints);
	PlayerStatus = new TStatic(this, idsStatus);
	StatusFrom = new TStatic(this, idsFrom);
	StatusTo = new TStatic(this, idsTo);
	PlayButton = new TODAButton3(this, idcPlay, idbButtonUp, idbPlay);
	StopButton = new TODAButton3(this, idcStop, idbButtonUp, idbStop);
	new TODAButton3(this, idcPause, idbButtonUp, idbPause);
	new TODAButton3(this, idcRewind, idbButtonUp, idbRewind);
	new TODAButton3(this, idcFastForward, idbButtonUp, idbFastForward);
	new TODAButton3(this, idcRecord, idbButtonUp, idbRecord);
	new TODAButton3(this, idcFrameAdvance, idbButtonUp, idbFrameAdvance);
	new TODAButton3(this, idcFrameBack, idbButtonUp, idbFrameBack);
	new TODAButton4(this, idcFileOpen, idbUp, idbFileOpen, Hint);
	new TODAButton4(this, idcFileSave, idbUp, idbFileSave, Hint);
	new TODAButton4(this, idcNewFile, idbUp, idbFileNew, Hint);
	new TODAButton4(this, idcDevCaps, idbUp, idbDevCaps, Hint);
	ErStart = new TODAButton4(this, idcErasetoStart, idbUp, idbEraseStart, Hint);
	ErEnd = new TODAButton4(this, idcErasetoEnd, idbUp, idbEraseEnd, Hint);
	ErAll = new TODAButton4(this, idcEraseAll, idbUp, idbEraseAll, Hint);
	new TODAButton4(this, idcAbout, idbUp, idbAbout, Hint);
	RecordModeSwitch = new TODACheckBox(this, idcRecordMode, idbSwitch1Up);
	VideoBtn = new TODACheckBox(this, idcVideo, idbRndBtnUp);
	AudioBtn = new TODACheckBox(this, idcAudio, idbRndBtnUp);
	FileStatic = new TStatic(this, idsFilename);
	LengthStatic = new TStatic(this, idsLength);
	PositionStatic = new TStatic(this, idsPosition);   
	PlayStatic = new TStatic(this, idsPlayStatic);
	VideoStatic = new TStatic(this, idsVideo1);
	AudioStatic = new TStatic(this, idsAudio1);
	PlayNormal = new TRadioButton(this, idcPlayNormal);
	PlayFast = new TRadioButton(this, idcPlayFast);
	PlaySlow = new TRadioButton(this, idcPlaySlow);
	SliderStatic = new TStatic(this, idsSliderStatic);
	VolumeStatic = new TStatic(this, idsVolumeStatic);
	Player = new TMMPlayer(HWindow);
	Marker = new TKMarker(this, idsMarker, 0, Player);
	LastPosition = Status = 0;
	strcpy(Filename, "untitled");
}

void
TMainDlg::SetupWindow()
{
	TDialog::SetupWindow();
	Player->SetParent(HWindow);
	TRect rect;
	GetWindowRect(rect);
	int w = rect.Width();
	int h = rect.Height();
	int x = (GetSystemMetrics(SM_CXSCREEN)/2)-(w/2);
	int y = (GetSystemMetrics(SM_CYSCREEN)/2)-(h/2);
	GetApplication()->MainWindow->MoveWindow(x, y, w, h);
	SliderStatic->GetWindowRect(rect);
	TPoint point = rect.TopLeft();
	ScreenToClient(point);
	Slider = new THSlider(this, idSlider,
		point.x, point.y,	rect.Width(), rect.Height());
	Slider->Create();
	VolumeStatic->GetWindowRect(rect);
	point = rect.TopLeft();
	ScreenToClient(point);
	VolumeControl = new TVSlider(this, idVolume,
		point.x, point.y, rect.Width(), rect.Height());
	VolumeControl->Create();
	FileStatic->SetText(Filename);
	RecordModeSwitch->SetCheck(BF_CHECKED);
	VolumeControl->SetRange(0, 100);
	UINT i = 100-((LOWORD(Player->GetVolume())/655.36));
	VolumeControl->SetPosition(i);
	PlayNormal->SetCheck(BF_CHECKED);
	RecordModeSwitch->Show(SW_HIDE);
	AudioBtn->SetCheck(BF_CHECKED);
	VideoBtn->SetCheck(BF_CHECKED);
	ShowEditButtons(SW_HIDE);
}

void
TMainDlg::EvTimer(UINT)
{
	static DWORD oldPos;
	if (!Player->IsOpen()) {KillTimer(1); return;}
	DWORD x = Player->GetPosition();
	if (oldPos == x) return;
	UpdateStatus();
	sprintf(Pos, "%ld", x);
	PositionStatic->SetText(Pos);
	Slider->SetPosition((int)x);
	oldPos = x;
}

void
TMainDlg::EvHScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl)
{
	if (!Player->IsOpen()) return;
	char str[8];
	Player->SetPosition(Slider->GetPosition());
	sprintf(str, "%ld", Player->GetPosition());
	PositionStatic->SetText(str);
	TDialog::EvHScroll(scrollCode, thumbPos, hWndCtl);
}

void
TMainDlg::EvVScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl)
{
	if (!Player->IsOpen()) return;
	TDialog::EvVScroll(scrollCode, thumbPos, hWndCtl);
}

void
TMainDlg::EvMouseMove(UINT, TPoint&)
{
	char str[20];
	Hint->GetText(str, sizeof(str));
	if (!strcmp(str, "")) return;
	Hint->SetText("");
}

void
TMainDlg::CmFileOpen()
{
  ShowEditButtons(SW_HIDE);
	Slider->SetPosition(0);
  Marker->EraseAll();
	if (Player->IsOpen()) Player->Close();
	RecordModeSwitch->Show(SW_HIDE);
	strcpy(filenameData.FileName, "");
	if ((new TFileOpenDialog(this,
		filenameData))->Execute() == IDOK) {
		if (filenameData.Error == 0) { // no error and not cancelled
			strcpy(Filename, filenameData.FileName);
		}
	}
	else return;
	Player->Open(Filename);
	DevType = Player->GetDeviceCaps(MCI_GETDEVCAPS_DEVICE_TYPE);
	if (DevType == MCI_DEVTYPE_DIGITAL_VIDEO) {
		VideoBtn->Show(SW_NORMAL);
		AudioBtn->Show(SW_NORMAL);
		VideoStatic->Show(SW_NORMAL);
		AudioStatic->Show(SW_NORMAL);
	}
	else {
		VideoBtn->Show(SW_HIDE);
		AudioBtn->Show(SW_HIDE);
		VideoStatic->Show(SW_HIDE);
		AudioStatic->Show(SW_HIDE);
	}
	if (DevType == MCI_DEVTYPE_ANIMATION) {
		PlayNormal->Show(SW_NORMAL);
		PlayFast->Show(SW_NORMAL);
		PlaySlow->Show(SW_NORMAL);
		PlayStatic->Show(SW_NORMAL);
	}
	else {
		PlayNormal->Show(SW_HIDE);
		PlayFast->Show(SW_HIDE);
		PlaySlow->Show(SW_HIDE);
		PlayStatic->Show(SW_HIDE);
	}
	FileStatic->SetText(Filename);
	MediaLength = Player->GetLength();
	Slider->SetRange(1, (int)MediaLength);
	Slider->SetRuler((int)MediaLength/10);
	Slider->SetPosition(1);
	UpdateScreenData();
}

void
TMainDlg::CmFileSave()
{
	if ((new TFileSaveDialog(this,
		filenameData))->Execute() == IDOK) {
		if (filenameData.Error == 0) { // no error and not cancelled
			strcpy(Filename, filenameData.FileName);
		}
	}
	Player->Save(Filename);
	RecordModeSwitch->Show(SW_HIDE);
}

void
TMainDlg::CmAbout()
{
	TDialog(this, iddAbout).Execute();
}

void
TMainDlg::NewFile()
{
	Slider->SetPosition(0);
	Marker->EraseAll();
	Player->Close();
	Player->Open("", "waveaudio");
	RecordModeSwitch->Show(SW_NORMAL);
	MediaLength = 0;
	strcpy(Filename, "untitled");
	UpdateScreenData();
}

void
TMainDlg::Play()
{
	if (!Player->IsOpen()) return;
	SetTimer(1,1);
	DWORD flags = MCI_NOTIFY;
	if (DevType == MCI_DEVTYPE_ANIMATION) {
		if (PlayNormal->GetCheck()) flags = MCI_NOTIFY;
		if (PlayFast->GetCheck()) flags = MCI_NOTIFY | MCI_ANIM_PLAY_FAST;
		if (PlaySlow->GetCheck()) flags = MCI_NOTIFY | MCI_ANIM_PLAY_SLOW;
	}
	if (VideoBtn->IsWindowVisible()) {
		VideoButton();
		AudioButton();
	}
	if (!Marker->From && !Marker->To) Player->Play(flags);
	else Player->Play(Marker->From, Marker->To, MCI_NOTIFY);
}

void              
TMainDlg::Stop()
{
	DWORD mode = Player->GetStatus();
	Player->Stop();
	if (mode == MCI_MODE_RECORD) {
		Player->Rewind();
		MediaLength = Player->GetLength();
		UpdateScreenData();
	}
}

void
TMainDlg::Pause()
{
	Player->Pause();
}

void
TMainDlg::Rewind()
{
	if (Marker->From) Player->Seek(Marker->From);
	else Player->Rewind();
	UpdateScreenData();
}

void
TMainDlg::FastForward()
{
	if (Marker->To) Player->Seek(Marker->To);
	else Player->FastForward();
	UpdateScreenData();
}

void
TMainDlg::Record()
{
	ShowEditButtons(SW_NORMAL);
	DWORD flags = 0;
	int mode = RecordModeSwitch->GetCheck();
	if (mode == 1) flags = flags | MCI_RECORD_OVERWRITE;
	else flags = flags | MCI_RECORD_INSERT;
	Player->Record(flags, Marker->From, Marker->To);
}

void
TMainDlg::EraseAll()
{
	Marker->EraseAll();
	if (Marker->From) Player->Delete(Marker->From, Marker->To);
	else Player->Erase();
}

void
TMainDlg::ErasetoStart()
{
	Player->Delete(0, Marker->From);
	MediaLength = Player->GetLength();
	Marker->EraseAll();
	UpdateScreenData();
}

void
TMainDlg::ErasetoEnd()
{
	Player->Delete(Marker->To, Player->GetLength());
	MediaLength = Player->GetLength();
	Marker->To = MediaLength;
	UpdateScreenData();
}

void
TMainDlg::FrameAdvance()
{
	DWORD pos = Player->GetPosition();
	if (Marker->To && pos >= Marker->To) return;
	Player->SetPosition(pos + 1);
	UpdateScreenData();
}

void
TMainDlg::FrameBack()
{
	DWORD pos = Player->GetPosition();
	if (Marker->From && pos <= Marker->From) return;
	Player->SetPosition(pos - 1);
	UpdateScreenData();
}

void
TMainDlg::SetVolume()
{
	Player->SetVolume(100 - VolumeControl->GetPosition());
	Slider->Invalidate(FALSE);
}

void
TMainDlg::VideoButton()
{
	if (VideoBtn->GetCheck()) Player->SetVideoOn();
	else Player->SetVideoOff();
}

void
TMainDlg::AudioButton()
{

	if (AudioBtn->GetCheck()) Player->SetAudioOn();
	else Player->SetAudioOff();
}

void
TMainDlg::UpdateScreenData()
{
	char str[10];
	sprintf(str, "%ld", Player->GetPosition());
	PositionStatic->SetText(str);
	sprintf(str, "%ld", Player->GetLength());
	LengthStatic->SetText(str);
	Slider->SetPosition((int)Player->GetPosition());
	UpdateStatus();
	UpdateMarkerData();
}

void
TMainDlg::UpdateMarkerData()
{
	if (!Player->IsOpen()) return;
	char str[10];
	if (Marker->From) {
		sprintf(str, "In: %ld", Marker->From);
		StatusFrom->SetText(str);
	}
	if (Marker->To) {
		sprintf(str, "Out: %ld", Marker->To);
		StatusTo->SetText(str);
	}
	return;
}

void
TMainDlg::UpdateStatus()
{
	char str[10], status[10];
	HINSTANCE HInstance = GetModule()->GetInstance();
	LoadString(HInstance, (UINT)Player->GetStatus(), status, sizeof(status));
	PlayerStatus->GetText(str, sizeof(str));
	if (!strcmp(str, status)) return;
	PlayerStatus->SetText(status);
}

void
TMainDlg::ShowDevCaps()
{
	if (!Player->IsOpen()) return;
	TCapsDlg* CapsDlg = new TCapsDlg(this, iddCaps, Player);
	CapsDlg->Execute();
	Invalidate();
}

void
TMainDlg::ShowEditButtons(UINT sw)
{
	ErStart->Show(sw);
	ErEnd->Show(sw);
	ErAll->Show(sw);
}

LRESULT
TMainDlg::MciNotify(WPARAM, LPARAM)
{
	KillTimer(1);
	UpdateScreenData();
	return 0;
}

LRESULT
TMainDlg::MarkerNotify(WPARAM, LPARAM)
{
	UpdateMarkerData();
}

class TTestApp : public TApplication {
	public:
		TTestApp() : TApplication() {}
		void InitMainWindow()
		{
			EnableCtl3d();
			TMainDlg* MainDlg = new TMainDlg(0, iddMain);
			MainWindow = new TFrameWindow(0, "Recorder",
					MainDlg, TRUE);
			MainWindow->Attr.Style &= ~(WS_MAXIMIZEBOX | WS_THICKFRAME);
		}
};

int OwlMain(int /*argc*/, char* /*argv*/ [])
{
	return TTestApp().Run();
}
