#include "odacheck.h"

DEFINE_RESPONSE_TABLE1(TODACheckBox, TCheckBox)
	EV_NOTIFY_AT_CHILD(BN_CLICKED, BNClicked),
END_RESPONSE_TABLE;

TODACheckBox::TODACheckBox(TWindow* parent, int resId, int bm)
 : TCheckBox(parent, resId)
{
	bmId = bm;
	Checked = TRUE;
}

void
TODACheckBox::SetupWindow()
{
	TCheckBox::SetupWindow();
	HINSTANCE HInstance = GetModule()->GetInstance();
	TRect rct = GetWindowRect();
	TPoint ulpoint = rct.TopLeft();
	TBitmap* bm = new TBitmap(HInstance, bmId);
	TPoint lrpoint(ulpoint.x + bm->Width(), ulpoint.y + bm->Height());
	Parent->ScreenToClient(ulpoint);
	Parent->ScreenToClient(lrpoint);
	MoveWindow(ulpoint.x, ulpoint.y,
							lrpoint.x - ulpoint.x, lrpoint.y - ulpoint.y);
	delete bm;
}

void
TODACheckBox::BNClicked()
{
	Toggle();
	TCheckBox::BNClicked();
	Invalidate(FALSE);
	UpdateWindow();
}

void
TODACheckBox::ODADrawEntire(DRAWITEMSTRUCT far& drawInfo)
{
	TDC dc(drawInfo.hDC);
	HINSTANCE HInstance = GetModule()->GetInstance();
	TMemoryDC memdc(dc);
	TBitmap* bmBtnUp = new TBitmap(HInstance, bmId);
	TBitmap* bmBtnDn = new TBitmap(HInstance, bmId + 2000);
	TRect bmRect(drawInfo.rcItem.left, drawInfo.rcItem.top,
								 drawInfo.rcItem.right, drawInfo.rcItem.bottom);
	if (Checked == BF_CHECKED) {
		memdc.SelectObject(*bmBtnUp);
		dc.BitBlt(bmRect, memdc, TPoint(0,0), SRCCOPY);
	}
	else {
		memdc.SelectObject(*bmBtnDn);
		dc.BitBlt(bmRect, memdc, TPoint(0,0), SRCCOPY);
	}
	//if (drawInfo.itemState & ODS_FOCUS)
	//	dc.DrawFocusRect(1, 1, 10, 10);

	delete bmBtnUp;
	delete bmBtnDn;
}

void
TODACheckBox::ODAFocus(DRAWITEMSTRUCT far& drawInfo)
{
	//TDC dc(drawInfo.hDC);
	//dc.DrawFocusRect(1, 1, 10, 10);
}

void
TODACheckBox::ODASelect(DRAWITEMSTRUCT far& drawInfo)
{
	ODADrawEntire(drawInfo);
}

