#ifndef __ODA_H
#include "oda.h"
#endif

// I had to include the response table entry to override
// BmSetStyle to get rid of a flash when the buttons were
// redrawn. I duplicated TButton's BMSetStyle except that I
// added FALSE to the Invalidate() call.

DEFINE_RESPONSE_TABLE2(TODAButton, TButton, TControl)
  EV_WM_MOUSEMOVE,
  EV_MESSAGE(BM_SETSTYLE, BMSetStyle),
END_RESPONSE_TABLE;

void
TODAButton::SetupWindow()
{
	TButton::SetupWindow();
	HINSTANCE HInstance = GetModule()->GetInstance();
	TRect rct = GetWindowRect();
	TPoint ulpoint = rct.TopLeft();
	TBitmap* bm = new TBitmap(HInstance, bmId);
	TPoint lrpoint(ulpoint.x + (bm->Width()+2), ulpoint.y + (bm->Height()+2));
	Parent->ScreenToClient(ulpoint);
	Parent->ScreenToClient(lrpoint);
	MoveWindow(ulpoint.x, ulpoint.y,
							lrpoint.x - ulpoint.x, lrpoint.y - ulpoint.y);
	delete bm;
}

LRESULT
TODAButton::BMSetStyle(WPARAM wParam, LPARAM)
{
	if ((Attr.Style & BS_OWNERDRAW) != BS_OWNERDRAW)
	 DefaultProcessing();

	else if (wParam == BS_DEFPUSHBUTTON) {
	 IsCurrentDefPB = TRUE;
	 Invalidate(FALSE);

	} else if (wParam == BS_PUSHBUTTON) {
		IsCurrentDefPB = FALSE;
	 Invalidate(FALSE);

	} else {
		DefaultProcessing();
  }

  return 0;
}

void
TODAButton::ODADrawEntire(DRAWITEMSTRUCT far& drawInfo)
{
	TDC dc(drawInfo.hDC);
	HINSTANCE HInstance = GetModule()->GetInstance();
	TMemoryDC memdc(dc);
	TBitmap* bmBtnUp = new TBitmap(HInstance, bmId);
	TBitmap* bmBtnDn = new TBitmap(HInstance, bmId+2000);
	TRect rect(drawInfo.rcItem.left, drawInfo.rcItem.top,
								 drawInfo.rcItem.right, drawInfo.rcItem.bottom);
	TRect bmRect(drawInfo.rcItem.left+1, drawInfo.rcItem.top+1,
								 drawInfo.rcItem.right, drawInfo.rcItem.bottom);
	TBrush* brush;
	if (drawInfo.itemState & ODS_FOCUS)
		brush = new TBrush(TColor::Black);
	else
		brush = new TBrush(TColor::LtGray);
	dc.SelectObject(*brush);
	dc.Rectangle(rect);
	if (drawInfo.itemState & ODS_SELECTED) {
		memdc.SelectObject(*bmBtnDn);
		dc.BitBlt(bmRect, memdc, TPoint(0,0), SRCCOPY);
	}
	else {
		memdc.SelectObject(*bmBtnUp);
		dc.BitBlt(bmRect, memdc, TPoint(0,0), SRCCOPY);
	}
	delete brush;
	delete bmBtnUp;
	delete bmBtnDn;
}

void
TODAButton3::ODADrawEntire(DRAWITEMSTRUCT far& drawInfo)
{
	TDC dc(drawInfo.hDC);
	HINSTANCE HInstance = GetModule()->GetInstance();
	TMemoryDC memdc(dc);
	TBitmap* bmBtnUp = new TBitmap(HInstance, bmId);
	TBitmap* bmBtnDn = new TBitmap(HInstance, bmId + 1);
	TBitmap* bmBtnFace = new TBitmap(HInstance, bm2Id);
	TRect rect(drawInfo.rcItem.left, drawInfo.rcItem.top,
								 drawInfo.rcItem.right, drawInfo.rcItem.bottom);
	TRect bmRect(drawInfo.rcItem.left+1, drawInfo.rcItem.top+1,
								 drawInfo.rcItem.right, drawInfo.rcItem.bottom);
	TBrush* brush;
	if (drawInfo.itemState & ODS_FOCUS)
		brush = new TBrush(TColor::Black);
	else
		brush = new TBrush(TColor::LtGray);
	dc.SelectObject(*brush);
	dc.Rectangle(rect.InflatedBy(1, 1));
	if (drawInfo.itemState & ODS_SELECTED) {
		memdc.SelectObject(*bmBtnDn);
		dc.BitBlt(bmRect, memdc, TPoint(0,0), SRCCOPY);
		memdc.SelectObject(*bmBtnFace);
		dc.BitBlt(bmRect.OffsetBy(3,3), memdc, TPoint(0,0), SRCCOPY);
	}
	else {
		memdc.SelectObject(*bmBtnUp);
		dc.BitBlt(bmRect, memdc, TPoint(0,0), SRCCOPY);
		memdc.SelectObject(*bmBtnFace);
		dc.BitBlt(bmRect.OffsetBy(2,2), memdc, TPoint(0,0), SRCCOPY);
	}
	delete brush;
	delete bmBtnUp;
	delete bmBtnDn;
	if (bmBtnFace) delete bmBtnFace;
}

void
TODAButton4::EvMouseMove(UINT /*modkeys*/, TPoint& point)
{
	char str[50], str2[50];
	TButton::EvMouseMove(0, point);
	HINSTANCE HInstance = GetModule()->GetInstance();
	LoadString(HInstance, bm2Id, str, sizeof(str));
	HintLine->GetText(str2, sizeof(str2));
	if (!strcmp(str, str2)) return;
	HintLine->SetText(str);
}


