#ifndef __MARKER_H
#include "marker.h"
#endif
#include "recorder.rh"

DEFINE_RESPONSE_TABLE1(TKMarker, TStatic)
	EV_WM_PAINT,
	EV_WM_LBUTTONDOWN,
	EV_WM_LBUTTONUP,
	EV_WM_RBUTTONUP,
	EV_WM_MOUSEMOVE,
	EV_WM_NCHITTEST,
END_RESPONSE_TABLE;

TKMarker::TKMarker(TWindow* parent, int resId, UINT textlen, TMMPlayer* player)
			: TStatic(parent, resId, textlen)
{
	bmFrom = new TBitmap(GetModule()->GetInstance(), idbFromMark);
	bmTo = new TBitmap(GetModule()->GetInstance(), idbToMark);
	From = To = 0;
	Dragging = FALSE;
	Player = player;
}

TKMarker::~TKMarker()
{
	delete bmFrom;
	delete bmTo;
	delete dc;
	delete memdc;
}

void
TKMarker::SetupWindow()
{
	Width = Attr.W;
	dc = new TClientDC(*this);
	memdc = new TMemoryDC(*dc);
}

void
TKMarker::EvPaint()
{
	TStatic::EvPaint();
	if (!From && !To) return;
	TPoint point = FromRect.TopLeft();
	DrawMarker(point, FROM);
	point = ToRect.TopLeft();
	DrawMarker(point, TO);
}

void
TKMarker::EvLButtonDown(UINT /*modkeys*/, TPoint& point)
{
  if (Player->GetStatus() == MCI_MODE_PLAY) return;
	SetCapture();
	//if (From && To) {
		if (From && FromRect.Contains(point)) {
			memdc->SelectObject(*bmFrom);
			Dragging = FROM;
			Src = FromRect;
		}
		if (To && ToRect.Contains(point)) {
			memdc->SelectObject(*bmTo);
			Dragging = TO;
			Src = ToRect;
		}
	//}
}

void
TKMarker::EvLButtonUp(UINT /*modkeys*/, TPoint& point)
{
	//if (!MainDlg->Player->IsOpen()) return;
	mediaLength = Player->GetLength();
	ReleaseCapture();
	if (Dragging) {
		if (Dragging == FROM) {
			FromRect = TRect(point.x, 1,
					point.x + bmTo->Width(), bmTo->Height() + 1);
			From = ((point.x * mediaLength)/Width);
			if (point.x < 6) From = 0;
		}
		if (Dragging == TO) {
			ToRect = TRect(point.x, 1,
					point.x + bmTo->Width(), bmTo->Height() + 1);
			To = ((point.x * mediaLength)/Width);
			if (point.x > (Width-6)) To = 0;
		}
		Dragging = FALSE;
		::SendMessage(GetParent(), MM_MARKERNOTIFY, 0, 0);
		return;
	}
	Dragging = FALSE;
	if (To && From) return;
	if (To) if (point.x > TPoint(ToRect.TopLeft()).x) return;
	if (!From) {
		FromRect = TRect(point.x, 1,
						point.x + bmFrom->Width(), bmFrom->Height()+1);
		From = ((point.x * mediaLength)/Width);
		DrawMarker(point, FROM);
	}
}

void
TKMarker::EvRButtonUp(UINT /*modkeys*/, TPoint& point)
{
	mediaLength = Player->GetLength();
	if (point.x < TPoint(FromRect.TopLeft()).x) return;
	ToRect = TRect(point.x, 1,
						point.x + bmTo->Width(), bmTo->Height()+1);
	To = ((point.x * mediaLength)/Width);
	DrawMarker(point, TO);
}

void
TKMarker::EvMouseMove(UINT /*modkeys*/, TPoint& point)
{
	if (!Dragging) return;
	if (Dragging == FROM)
		if (point.x > (TPoint(ToRect.TopLeft()).x - 6)) return;
	if (Dragging == TO) 
		if (point.x < (TPoint(FromRect.TopLeft()).x + 6)) return;
	dc->FillRect(Src, TBrush(TColor::LtGray));
	dc->BitBlt(point.x, 1, bmFrom->Width(), bmFrom->Height()+1,
				*memdc, 0, 0, SRCCOPY);
	Src = TRect(point.x, 1,
			point.x + bmFrom->Width(), bmFrom->Height()+1);
}

void
TKMarker::DrawMarker(TPoint& point, int marker)
{
	TBitmap* bitmap;
	if (marker == FROM) bitmap = bmFrom;
	else bitmap = bmTo;
	memdc->SelectObject(*bitmap);
	dc->BitBlt(point.x, 1, bmFrom->Width(), bmFrom->Height()+1,
			*memdc, 0, 0, SRCCOPY);
	::SendMessage(GetParent(), WM_USER + 1, 0, 0);
}

void
TKMarker::EraseAll()
{
	From = To = 0;
	TRect rect = GetClientRect();
	dc->FillRect(rect, TBrush(TColor::LtGray));
	Invalidate(TRUE);
}
