/////////////////////////////////////////////////////////////////////
//                                                                 //
// CAPSDLG.CPP module for RECORDER.CPP
// displays device capabilities in a dialog box
//                                                                 //
//                                                                 //
/////////////////////////////////////////////////////////////////////

#include "capsdlg.h"
#include "recorder.rh"

TCapsDlg::TCapsDlg(TWindow* parent, int resId, TMMPlayer* player)
			: TDialog(parent, resId), TWindow(parent)
{
	Player = player;
	Eject = new TStatic(this, idsEject);
	Play = new TStatic(this, idsPlay);
	Record = new TStatic(this, idsRecord);
	Save = new TStatic(this, idsSave);
	Compound = new TStatic(this, idsCompound);
	DeviceType = new TStatic(this, idsDeviceType);
	Audio = new TStatic(this, idsAudio);
	Video = new TStatic(this, idsVideo);
	Files = new TStatic(this, idsFiles);
	for (int i=0;i<8;i++) {
			Text[i] = new TStatic(this, idsText1+i);
			Aux[i] = new TStatic(this, idsAux1+i);
	}
}

void
TCapsDlg::SetupWindow()
{
	TDialog::SetupWindow();
	DevType = Player->GetDeviceType();
	char str[80];
	Player->GetDeviceName(str);
	DeviceType->SetText(str);
	Display(Eject, Player->CanEject());
	Display(Play, Player->CanPlay());
	Display(Record, Player->CanRecord());
	Display(Save, Player->CanSave());
	Display(Compound, Player->GetDeviceCaps(MCI_GETDEVCAPS_COMPOUND_DEVICE));
	Display(Audio, Player->HasAudio());
	Display(Video, Player->HasVideo());
	Display(Files, Player->UsesFiles());
	ShowMore();
}

void
TCapsDlg::Display(TStatic* stat, DWORD res)
{
	char str[10];
	sprintf(str, "%ld", res);
	if (res == TRUE) strcpy(str, "YES");
	if (res == FALSE) strcpy(str, "NO");
	if (res == MCIERR_UNSUPPORTED_FUNCTION) strcpy(str, "N/A");
	stat->SetText(str);
}

void
TCapsDlg::ShowMore()
{
	switch (DevType) {
		case MCI_DEVTYPE_ANIMATION : ShowAnimationExt(); break;
		case MCI_DEVTYPE_DIGITAL_VIDEO : ShowVideoExt(); break;
		case MCI_DEVTYPE_WAVEFORM_AUDIO : ShowWaveExt(); break;
	}
}

void
TCapsDlg::ShowAnimationExt()
{
	Text[0]->SetText("Can Reverse:");
	Text[1]->SetText("Can Stretch:");
	Text[2]->SetText("Max Windows:");
	Text[3]->SetText("Fast Rate:");
	Text[4]->SetText("Normal Rate:");
	Text[5]->SetText("Slow Rate:");
	Text[6]->SetText("Pallette Handles:");
	Display(Aux[0], Player->GetDeviceCaps(MCI_ANIM_GETDEVCAPS_CAN_REVERSE));
	Display(Aux[1], Player->GetDeviceCaps(MCI_ANIM_GETDEVCAPS_CAN_STRETCH));
	Display(Aux[2], Player->GetDeviceCaps(MCI_ANIM_GETDEVCAPS_MAX_WINDOWS));
	Display(Aux[3], Player->GetDeviceCaps(MCI_ANIM_GETDEVCAPS_FAST_RATE));
	Display(Aux[4], Player->GetDeviceCaps(MCI_ANIM_GETDEVCAPS_NORMAL_RATE));
	Display(Aux[5], Player->GetDeviceCaps(MCI_ANIM_GETDEVCAPS_SLOW_RATE));
	Display(Aux[6], Player->GetDeviceCaps(MCI_ANIM_GETDEVCAPS_CAN_STRETCH));
}

void
TCapsDlg::ShowVideoExt()
{
	Text[0]->SetText("Can Freeze:");
	Text[1]->SetText("Can Stretch:");
	Display(Aux[0], Player->GetDeviceCaps(MCI_OVLY_GETDEVCAPS_CAN_FREEZE));
	Display(Aux[1], Player->GetDeviceCaps(MCI_OVLY_GETDEVCAPS_CAN_STRETCH));
}

void
TCapsDlg::ShowWaveExt()
{
	char str[4];
	DWORD result;
	Text[0]->SetText("Input Devices:");
	Text[1]->SetText("Output Devices:");
	result = Player->GetDeviceCaps(MCI_WAVE_GETDEVCAPS_INPUTS);
	sprintf(str, "%ld", result);
	Aux[0]->SetText(str);
	result = Player->GetDeviceCaps(MCI_WAVE_GETDEVCAPS_OUTPUTS);
	sprintf(str, "%ld", result);
	Aux[1]->SetText(str);
}

